import java.util.GregorianCalendar;
import java.text.SimpleDateFormat;

public class Song {
    
    public static String definition;
    
    private String title;
    private String author;
    private int year;
    private GregorianCalendar releaseDate;
    
    static {
        definition = "Song is a nice piece of music.";
    }
    
    public Song(String title, String author, int year, GregorianCalendar releaseDate) {
        this.title = title;
        this.author = author;
        this.year = year;
        this.releaseDate = releaseDate;
    }
    
    public Song(String title, String author, GregorianCalendar releaseDate) {
        this.title = title;
        this.author = author;
        this.releaseDate = releaseDate;
        this.year = this.releaseDate.YEAR;
    }
    
    public Song(String title, String author, int year) {
        this.title = title;
        this.author = author;
        this.year = year;
    }
    
//     public Song(String title, String author, int year) {
//         this.author = author;
//     }
    
    public Song(String title, String author) {
        this.title = title;
        this.author = author;
    }
    
    public Song() {
    }
    
    public static void define() {
        System.out.println("Song is a nice piece of music.");
    }
    
    public void display() {
        System.out.println('\"' + title + '\"' + ':' + '\n' +
                           '\t' + "author: " + author + '\n' +
                           '\t' + "year: " + year);
    }
    
    public String toString() {
//         return this.title + ", " + this.author + " (" + this.year + ")";
        return this.title + ", " + this.author + " (" + (new SimpleDateFormat("MMM dd, yyyy")).format(this.releaseDate.getTime()) + ")";
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setAuthor(String author) {
        this.author = author;
    }
    
    public String getAuthor() {
        return this.author;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    public void setReleaseDate(GregorianCalendar releaseDate) {
        this.releaseDate = releaseDate;
    }
    
    public GregorianCalendar getReleaseDate() {
        return this.releaseDate;
    }
    
}
